/* this is a revised version of this file which takes account of the
time inconsistency of the responses in all 3 waves of RPED - output &
VAD is deflated by year to which data refers; capital stock is deflated
by year in which survey was undertaken */

/*  this programme creates pooled production data
and converts current prices into constant 1992 prices and
US$ and US$ppp values using Penn World Table exchange rates */


libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';


/* WAVE 1 INCLUDES 1992 AND 1993 PRODUCTION DATA HENCE VARIABLES
DEFLATED BY RESPECTIVE ANNUAL INDEX VALUE */

data temp1; set cd.genfirm1;

if period=1 then year=92;
if period ne 1 then year=93;

/* WAVE 1 = 1992 DATA */

if year=92 then do;

/* creating 1992 constant prices
CPI=156.8 CAP DEFLATOR = 300.84
since capital stock is 1993 value */

outcp=output;
matcp=rawmat;
misccp=misc;
vadcp=vad;
earncp=labcost;
capcp=cap/300.84*227.26;
profcp=prcalc;

out92cp=output;
mat92cp=matcp;
misc92cp=misccp;
vad92cp=vad;
earn92cp=labcost;
cap92cp=cap/300.84*227.26;
prof92cp=prcalc;

/* creating USD values */
outus=output/297.71;
matus=rawmat/297.71;
miscus=misc/297.71;
vadus=vad/297.71;
earnus=labcost/297.71;
capus=cap/405.27;
profus=prcalc/297.71;

out92us=output/297.71;
mat92us=rawmat/297.71;
misc92us=misc/297.71;
vad92us=vad/297.71;
earn92us=labcost/297.71;
cap92us=cap/405.27;
prof92us=prcalc/297.71;

/* creating USD ppp values  */
outusp=output/112.52;
matusp=rawmat/112.52;
miscusp=misc/112.52;
vadusp=vad/112.52;
earnusp=labcost/112.52;
capusp=cap/200.64;
profusp=prcalc/112.52;

out92usp=output/112.52;
mat92usp=rawmat/112.52;
mis92usp=misc/112.52;
vad92usp=vad/112.52;
ear92usp=labcost/112.52;
cap92usp=cap/200.64;
prf92usp=prcalc/112.52;

end;

if year=93 then do;

/* creating 1992 constant prices
CPI=156.8 CAP DEFLATOR = 300.84 */
outcp=output/196.4*156.8;
matcp=rawmat/196.4*156.8;
misccp=misc/196.4*156.8;
vadcp=vad/196.4*156.8;
earncp=labcost/196.4*156.8;
capcp=cap/300.84*227.26;
profcp=prcalc/196.4*156.8;

out92cp=output/196.4*156.8;
mat92cp=rawmat/196.4*156.8;
misc92cp=misc/196.4*156.8;
vad92cp=vad/196.4*156.8;
earn92cp=labcost/196.4*156.8;
cap92cp=cap/300.84*227.26;
prof92cp=prcalc/196.4*156.8;

/* creating USD values */
outus=output/405.27;
matus=rawmat/405.27;
miscus=misc/405.27;
vadus=vad/405.27;
earnus=labcost/405.27;
capus=cap/405.27;
profus=prcalc/405.27;

out92us=output/405.27;
mat92us=rawmat/405.27;
misc92us=misc/405.27;
vad92us=vad/405.27;
earn92us=labcost/405.27;
cap92us=cap/405.27;
prof92us=prcalc/405.27;

/* creating USD ppp values  */
outusp=output/140.44;
matusp=rawmat/140.44;
miscusp=misc/140.44;
vadusp=vad/140.44;
earnusp=labcost/140.44;
capusp=cap/200.64;
profusp=prcalc/140.44;

out92usp=output/140.44;
mat92usp=rawmat/140.44;
mis92usp=misc/140.44;
vad92usp=vad/140.44;
ear92usp=labcost/140.44;
cap92usp=cap/200.64;
prf92usp=prcalc/140.44;

end;


/* ratios */
vlcp=vadcp/emp;
klcp=capcp/emp;
vkcp=vadcp/capcp;

vl92cp=vadcp/emp;
kl92cp=capcp/emp;
vk92cp=vadcp/capcp;

vlus=vadus/emp;
klus=capus/emp;
vkus=vadus/capus;

vl92us=vadus/emp;
kl92us=capus/emp;
vk92us=vadus/capus;

vlusp=vadusp/emp;
klusp=capusp/emp;
vkusp=vadusp/capusp;

vl92usp=vadusp/emp;
kl92usp=capusp/emp;
vk92usp=vadusp/capusp;

proc sort; by firm wave;


/* WAVE 2 INCLUDES 1993 AND 1994 PRODUCTION DATA HENCE VARIABLES
DEFLATED BY RESPECTIVE ANNUAL INDEX VALUE */

data temp2; set cd.genfirm2;

if period=1 then year=93;
if period ne 1 then year=94;

if year=93 then do;

/* creating constant 1992 prices
CPI=196.4 CAP DEFLATOR = 385.52 since
cap figures are 1994*/

outcp=output/196.4*156.8;
matcp=rawmat/196.4*156.8;
misccp=misc/196.4*156.8;
vadcp=vad/196.4*156.8;
earncp=labcost/196.4*156.8;
profcp=prcalc/196.4*156.8;

out93cp=output/196.4*156.8;
mat93cp=rawmat/196.4*156.8;
misc93cp=misc/196.4*156.8;
vad93cp=vad/196.4*156.8;
earn93cp=labcost/196.4*156.8;
prof93cp=prcalc/196.4*156.8;

capcp=cap/385.52*227.26;
cap93cp=cap/385.52*227.26;

/* creating USD values */
outus=output/405.27;
matus=rawmat/405.27;
miscus=misc/405.27;
vadus=vad/405.27;
earnus=labcost/405.27;
capus=cap/405.27;
profus=prcalc/405.27;

out93us=output/405.27;
mat93us=rawmat/405.27;
misc93us=misc/405.27;
vad93us=vad/405.27;
earn93us=labcost/405.27;
cap93us=cap/405.27;
prof93us=prcalc/405.27;

/* creating USD ppp values  */
outusp=output/140.44;
matusp=rawmat/140.44;
miscusp=misc/140.44;
vadusp=vad/140.44;
earnusp=labcost/140.44;
capusp=cap/200.64;
profusp=prcalc/140.44;

out93usp=output/140.44;
mat93usp=rawmat/140.44;
mis93usp=misc/140.44;
vad93usp=vad/140.44;
ear93usp=labcost/140.44;
cap93usp=cap/200.64;
prf93usp=prcalc/140.44;

end;

if year=94 then do;

/* creating constant 1992 prices
CPI=261.4 Cap Deflator= 385.52*/

outcp=output/261.4*156.8;
matcp=rawmat/261.4*156.8;
misccp=misc/261.4*156.8;
vadcp=vad/261.4*156.8;
earncp=labcost/261.4*156.8;
profcp=prcalc/261.4*156.8;

out93cp=output/261.4*156.8;
mat93cp=rawmat/261.4*156.8;
misc93cp=misc/261.4*156.8;
vad93cp=vad/261.4*156.8;
earn93cp=labcost/261.4*156.8;
prof93cp=prcalc/261.4*156.8;

capcp=cap/385.52*227.26;
cap93cp=cap/385.52*227.26;

/* creating USD values */
outus=output/509.63;
matus=rawmat/509.63;
miscus=misc/509.63;
vadus=vad/509.63;
earnus=labcost/509.63;
capus=cap/509.63;
profus=prcalc/509.63;

out93us=output/509.63;
mat93us=rawmat/509.63;
misc93us=misc/509.63;
vad93us=vad/509.63;
earn93us=labcost/509.63;
cap93us=cap/509.63;
prof93us=prcalc/509.63;

/* creating USD ppp values  */
outusp=output/182.96;
matusp=rawmat/182.96;
miscusp=misc/182.96;
vadusp=vad/182.96;
earnusp=labcost/182.96;
capusp=cap/261.38;
profusp=prcalc/182.96;

out93usp=output/182.96;
mat93usp=rawmat/182.96;
mis93usp=misc/182.96;
vad93usp=vad/182.96;
ear93usp=labcost/182.96;
cap93usp=cap/261.38;
prf93usp=prcalc/182.96;

end;

/* ratios */

vlcp=vadcp/emp;
klcp=capcp/emp;
vkcp=vadcp/capcp;

vl93cp=vadcp/emp;
kl93cp=capcp/emp;
vk93cp=vadcp/capcp;

vlus=vadus/emp;
klus=capus/emp;
vkus=vadus/capus;

vl93us=vadus/emp;
kl93us=capus/emp;
vk93us=vadus/capus;

vlusp=vadusp/emp;
klusp=capusp/emp;
vkusp=vadusp/capusp;

vl93usp=vadusp/emp;
kl93usp=capusp/emp;
vk93usp=vadusp/capusp;

proc sort; by firm wave;



/* WAVE 3 INCLUDES 1994 AND 1995 PRODUCTION DATA HENCE VARIABLES
DEFLATED BY RESPECTIVE ANNUAL INDEX VALUE */

data temp3; set cd.genfirm3;

if year=94 then do;

/* creating constant 1992 prices
CPI=261.4 Cap Deflator= 457.03 since
cap is the 1995 value */

outcp=output/261.4*156.8;
matcp=rawmat/261.4*156.8;
misccp=misc/261.4*156.8;
vadcp=vad/261.4*156.8;
earncp=labcost/261.4*156.8;
profcp=prcalc/261.4*156.8;

out95cp=output/261.4*156.8;
mat95cp=rawmat/261.4*156.8;
misc95cp=misc/261.4*156.8;
vad95cp=vad/261.4*156.8;
earn95cp=labcost/261.4*156.8;
prof95cp=prcalc/261.4*156.8;

capcp=cap/457.03*227.26;
cap95cp=cap/457.03*227.26;

/* creating USD values */
outus=output/509.63;
matus=rawmat/509.63;
miscus=misc/509.63;
vadus=vad/509.63;
earnus=labcost/509.63;
capus=cap/509.63;
profus=prcalc/509.63;

out95us=output/509.63;
mat95us=rawmat/509.63;
misc95us=misc/509.63;
vad95us=vad/509.63;
earn95us=labcost/509.63;
cap95us=cap/509.63;
prof95us=prcalc/509.63;

/* creating USD ppp values  */
outusp=output/182.96;
matusp=rawmat/182.96;
miscusp=misc/182.96;
vadusp=vad/182.96;
earnusp=labcost/182.96;
capusp=cap/261.38;
profusp=prcalc/182.96;

out95usp=output/182.96;
mat95usp=rawmat/182.96;
mis95usp=misc/182.96;
vad95usp=vad/182.96;
ear95usp=labcost/182.96;
cap95usp=cap/261.38;
prf95usp=prcalc/182.96;

end;


if year=95 then do;

/* creating constant 1992 prices
CPI=339.3 Cap Deflator=457.03*/

outcp=output/339.3*156.8;
matcp=rawmat/339.3*156.8;
misccp=misc/339.3*156.8;
vadcp=vad/339.3*156.8;
earncp=labcost/339.3*156.8;
profcp=prcalc/339.3*156.8;

out95cp=output/339.3*156.8;
mat95cp=rawmat/339.3*156.8;
misc95cp=misc/339.3*156.8;
vad95cp=vad/339.3*156.8;
earn95cp=labcost/339.3*156.8;
prof95cp=prcalc/339.3*156.8;

capcp=cap/457.03*227.26;
cap95cp=cap/457.03*227.26;

/* creating USD values */
outus=output/574.76;
matus=rawmat/574.76;
miscus=misc/574.76;
vadus=vad/574.76;
earnus=labcost/574.76;
capus=cap/574.76;
profus=prcalc/574.76;

out95us=output/574.76;
mat95us=rawmat/574.76;
misc95us=misc/574.76;
vad95us=vad/574.76;
earn95us=labcost/574.76;
cap95us=cap/574.76;
prof95us=prcalc/574.76;

/* creating USD ppp values  */
outusp=output/226.17;
matusp=rawmat/226.17;
miscusp=misc/226.17;
vadusp=vad/226.17;
earnusp=labcost/226.17;
capusp=cap/323.11;
profusp=prcalc/226.17;

out95usp=output/226.17;
mat95usp=rawmat/226.17;
mis95usp=misc/226.17;
vad95usp=vad/226.17;
ear95usp=labcost/226.17;
cap95usp=cap/323.11;
prf95usp=prcalc/226.17;

end;

/* ratios */

vlcp=vadcp/emp;
klcp=capcp/emp;
vkcp=vadcp/capcp;

vl95cp=vadcp/emp;
kl95cp=capcp/emp;
vk95cp=vadcp/capcp;

vlus=vadus/emp;
klus=capus/emp;
vkus=vadus/capus;

vl95us=vadus/emp;
kl95us=capus/emp;
vk95us=vadus/capus;

vlusp=vadusp/emp;
klusp=capusp/emp;
vkusp=vadusp/capusp;

vl95usp=vadusp/emp;
kl95usp=capusp/emp;
vk95usp=vadusp/capusp;

proc sort; by firm wave;


/* CREATES MERGED DATA FILE BY FIRM AND WAVE */
/* ***************************************** */

data cd.pool1; merge temp1 temp2 temp3; by firm wave;

ratio=output/vad;

if wave=1 then wave1=1; else wave1=0;
if wave=2 then wave2=1; else wave2=0;
if wave=3 then wave3=1; else wave3=0;

if wave=1 then round=1;
if wave=2 then round=2;
if wave=3 then round=3;

proc means; var firm wave output vad emp cap vadcap capvad
outcp vadcp matcp misccp earncp profcp capcp
outus vadus matus miscus earnus profus capus
outusp vadusp matusp miscusp earnusp profusp capusp
vlcp klcp vkcp vlus klus vkus vlusp klusp vkusp; run;

proc sort; by firm round;



/* SOME DESCRIPTIVE STATISTICS */
/* *************************** */

/* note that these results vary from the results published
in the Harding & Teal (1999) firm report due to changes in the
sample used, with some firms excluded and some data revised
in the light of better Wave 4 data */

data ctabs1; set cd.pool1;

/* productivity and KL ratios by size and sector */
proc sort; by sizedum;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp ; by sizedum; run;

proc sort; by indlab;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp; by indlab; run;

/* firm growth by size and sector */
proc sort; by sizedum;
proc means; var firm out92cp out93cp out95cp outcp
vad92cp vad93cp vad95cp vadcp; by sizedum; run;

proc sort; by indlab;
proc means; var firm out92cp out93cp out95cp outcp
vad92cp vad93cp vad95cp vadcp; by indlab; run;

/* firm exports by size and sector */
proc sort; by sizedum;
proc means; var firm expdum exppc; by sizedum; run;

proc sort; by indlab;
proc means; var firm expdum exppc; by indlab; run;


/* 
proc print; var firm wave output vad emp cap vadcap capvad; run;
proc print; var firm wave output misc rawmat vad ratio; run;
proc print; var firm wave sizedum indlab loca; run;
*/

/* breakdown by firm age, ownership and unionisation */

data tempap; set cd.pool1;
proc sort; by firm;

data pooledb; merge tempap cd.firmage cd.owners; by firm;

proc sort; by agedum;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp ; by agedum; run;

proc sort; by union;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp ; by union; run;

proc sort; by anyfor;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp ; by anyfor; run;

proc sort; by anyst;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp ; by anyst; run;

proc sort; by state;
proc means; var firm emp capcp outcp vadcp klcp vlcp vkcp
capusp outusp vadusp klusp vlusp vkusp ; by state; run;

proc sort; by firm;
proc means; run;


/* tables for firm report */

data tables; set cd.pool1;

proc means; var firm vademp vl92cp; run;

title 'Productivity by Sector and Size';
proc tabulate;
class sizedum indlab;
var vad92cp vad93cp vad95cp vadcp vl92cp vl93cp vl95cp vlcp;

table (sizedum)*(mean n std), vl92cp vl93cp vl95cp vlcp;
table (indlab)*(mean n std), vl92cp vl93cp vl95cp vlcp;
run;


/* POOLED PRODUCTION FUNCTIONS */
/* *************************** */

data check4; set cd.pool1;
options nolabel;

if vad<= 0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvad=log(vad);
lemp=log(emp);
lcap=log(cap);

proc means; var firm vad emp cap vadcap capvad; run;
proc reg; model lvad=lcap lemp; run;

proc reg; model lvad=lcap lemp wave2 wave3;
run;

/* translog production function */

data check5; set cd.pool1;
options nolabel;

if vad<= 0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvad=log(vad);
lemp=log(emp);
lcap=log(cap);

lemp2=lemp*lemp;
lcap2=lcap*lcap;
lcapemp=lemp*lcap;

proc means; var firm vad emp cap vadcap capvad; run;

proc reg; model lvad=lcap lemp lemp2 lcap2 lcapemp;
run;

/* production function constant prices */

data check4; set cd.pool1;
options nolabel;

if vadcp<= 0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvadcp=log(vadcp);
lemp=log(emp);
lcapcp=log(capcp);

proc means; var firm vadcp emp capcp vadcap capvad; run;

proc reg; model lvadcp=lcapcp lemp; run;

proc reg; model lvadcp=lcapcp lemp food text wood
wave2 wave3; run;


data check4b; set pooledb;
options nolabel;

if vadcp<= 0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvadcp=log(vadcp);
lemp=log(emp);
lcapcp=log(capcp);

stsize=lemp*anyst;
forsize=lemp*anyfor;

proc reg; model lvadcp=lcapcp lemp; run;

proc reg; model lvadcp=lcapcp lemp food text wood
union anyst stsize anyfor forsize wave2 wave3; run;


/* production function ppp dollars */

data check5; set cd.pool1;
options nolabel;

if vadusp<= 0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvadusp=log(vadusp);
lemp=log(emp);
lcapusp=log(capusp);

proc means; var firm vadusp emp capusp vadcap capvad; run;

proc reg; model lvadusp=lcapusp lemp; run;

proc reg; model lvadusp=lcapusp lemp food text wood
wave2 wave3; run;


/* export performance */

data exp1; set cd.pool1;

proc means; var firm wave emp expdum exppc expaf expnaf; run;

proc sort; by sizedum;
proc means; var firm wave emp expdum exppc
expaf expnaf; by sizedum; run;

proc sort; by indlab;
proc means; var firm wave emp expdum exppc
expaf expnaf; by indlab; run;
